#!/bin/bash
set -e -x

wget \
	https://launchpad.net/~chris-lea/+archive/ubuntu/redis-server/+sourcefiles/redis/5:6.0.5-1chl1~xenial1/redis_6.0.5-1chl1~xenial1.debian.tar.xz \
	https://launchpad.net/~chris-lea/+archive/ubuntu/redis-server/+sourcefiles/redis/5:6.0.5-1chl1~xenial1/redis_6.0.5-1chl1~xenial1.dsc \
	https://launchpad.net/~chris-lea/+archive/ubuntu/redis-server/+sourcefiles/redis/5:6.0.5-1chl1~xenial1/redis_6.0.5.orig.tar.gz 
dpkg-source -x *.dsc

cd redis-*/

dch -v 6:6.0.5-1 'Bump version'
dch --local ".${UBUNTU_CODENAME}" ''
dch --release ''
DEB_BUILD_OPTIONS='parallel=2' debuild -e BUILD_TLS -b -uc -us

mkdir /tmp/${OUTPUT_DIR}/
mv ../*.deb /tmp/${OUTPUT_DIR}/

cd /tmp/
tar -cf "${OUTPUT_DIR}.tar" ${OUTPUT_DIR}
