#!/bin/bash
set -e -x

build_name=rsyslog
url_prefix='http://ppa.launchpad.net/adiscon/v8-stable/ubuntu/pool/main/'
rsyslog_version_amd64="8.2104.0-0adiscon1${UBUNTU_CODENAME}1_amd64"
rsyslog_version_all="8.2104.0-0adiscon1${UBUNTU_CODENAME}1_all"

case "${UBUNTU_CODENAME}" in
  'xenial')
    libestr_release='1i'
    ;;
  'bionic')
    libestr_release='2'
    ;;
  *)
    echo "What are you building?"
    exit 1
    ;;
esac
libestr_version_amd64="0.1.11-0adiscon${libestr_release}${UBUNTU_CODENAME}1_amd64"
libfastjson_version_amd64="0.99.9-0adiscon1${UBUNTU_CODENAME}1_amd64"
liblognnorm_version_amd64="2.0.6-0adiscon1${UBUNTU_CODENAME}1_amd64"

rm -rf /tmp/${build_name}/${OUTPUT_DIR}/
mkdir -p /tmp/${build_name}/${OUTPUT_DIR}

cd /tmp/${build_name}/${OUTPUT_DIR}/

for deb in \
  r/rsyslog/rsyslog-mysql_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-mmfields_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-openssl_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-relp_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-mongodb_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-utils_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-pmnormalize_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-mmkubernetes_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-mmutf8fix_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-mmnormalize_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-mmanon_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-redis_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-fmhttp_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-gnutls_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-omstdout_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-kafka_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-imptcp_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-pgsql_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-elasticsearch_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-fmhash_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-mmjsonparse_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-mmrm1stspace_${rsyslog_version_amd64}.deb \
  r/rsyslog/rsyslog-doc_${rsyslog_version_all}.deb \
  libe/libestr/libestr0_${libestr_version_amd64}.deb \
  libe/libestr/libestr-dev_${libestr_version_amd64}.deb \
  libf/libfastjson/libfastjson4_${libfastjson_version_amd64}.deb \
  libf/libfastjson/libfastjson-dev_${libfastjson_version_amd64}.deb \
  libl/liblognorm/liblognorm5_${liblognnorm_version_amd64}.deb \
  libl/liblognorm/liblognorm-dev_${liblognnorm_version_amd64}.deb 
do
  wget ${url_prefix}${deb}
done

cd /tmp/${build_name}/
tar -cvf "/tmp/${OUTPUT_DIR}.tar" "${OUTPUT_DIR}"
