package client

import (
	"CoralGoCodec/codec"
	"testing"
)

func TestWithCustomHeaders(t *testing.T) {
	testCodecRequest := &codec.Request{}
	amzDateHeader := "X-Amz-Date"
	amzDate := "2019-12-24T12:12:12-08:00"
	headers := map[string]string{
		amzDateHeader: amzDate,
	}
	WithCustomHeaders(headers)(testCodecRequest)
	actualHeaders := testCodecRequest.RequestHeaders

	if got := actualHeaders[amzDateHeader]; got != amzDate {
		t.Errorf("Header %q value mismatch: got: %q, want: %q. Entire header: %#v", amzDateHeader, got, amzDate, actualHeaders)
	}
}
