package com_amazon_coral_service

import (
	__model__ "CoralGoModel/model"
	__reflect__ "reflect"
)

func init() {
	var val *string
	t := __reflect__.TypeOf(&val).Elem()
	fun := func(from __reflect__.Value) __reflect__.Value {
		var to *string
		if f, ok := from.Interface().(*string); ok {
			to = f
		} else {
			panic("Can't Convert from " + from.Type().Name() + " to ServiceErrorMessage")
		}
		return __reflect__.ValueOf(to)
	}
	__model__.RegisterConverter(t, fun)
}
func init() {
	var val *string
	t := __reflect__.TypeOf(&val).Elem()
	fun := func(from __reflect__.Value) __reflect__.Value {
		var to *string
		if f, ok := from.Interface().(*string); ok {
			to = f
		} else {
			panic("Can't Convert from " + from.Type().Name() + " to OrchestratorErrorMessage")
		}
		return __reflect__.ValueOf(to)
	}
	__model__.RegisterConverter(t, fun)
}

type MalformedHttpRequestException interface {
	error
	HTTPResponseCode() int
	SetMessage(v *string)
	Message() *string
}
type _MalformedHttpRequestException struct {
	Ị_Message *string `coral:"Message" json:"Message"`
}

func (this *_MalformedHttpRequestException) Error() string {
	return __model__.ErrorMessage(this)
}
func (this *_MalformedHttpRequestException) HTTPResponseCode() int {
	return 400
}
func (this *_MalformedHttpRequestException) Message() *string {
	return this.Ị_Message
}
func (this *_MalformedHttpRequestException) SetMessage(v *string) {
	this.Ị_Message = v
}
func NewMalformedHttpRequestException() MalformedHttpRequestException {
	return &_MalformedHttpRequestException{}
}
func init() {
	var val MalformedHttpRequestException
	t := __reflect__.TypeOf(&val)
	__model__.LookupService("UnknownService").Assembly("com.amazon.coral.service").RegisterShape("MalformedHttpRequestException", t, func() interface{} {
		return NewMalformedHttpRequestException()
	})
}

type RequestEntityTooLargeException interface {
	error
	HTTPResponseCode() int
	SetMessage(v *string)
	Message() *string
}
type _RequestEntityTooLargeException struct {
	Ị_Message *string `coral:"Message" json:"Message"`
}

func (this *_RequestEntityTooLargeException) Error() string {
	return __model__.ErrorMessage(this)
}
func (this *_RequestEntityTooLargeException) HTTPResponseCode() int {
	return 413
}
func (this *_RequestEntityTooLargeException) Message() *string {
	return this.Ị_Message
}
func (this *_RequestEntityTooLargeException) SetMessage(v *string) {
	this.Ị_Message = v
}
func NewRequestEntityTooLargeException() RequestEntityTooLargeException {
	return &_RequestEntityTooLargeException{}
}
func init() {
	var val RequestEntityTooLargeException
	t := __reflect__.TypeOf(&val)
	__model__.LookupService("UnknownService").Assembly("com.amazon.coral.service").RegisterShape("RequestEntityTooLargeException", t, func() interface{} {
		return NewRequestEntityTooLargeException()
	})
}

type UnknownOperationException interface {
	error
	HTTPResponseCode() int
	SetMessage(v *string)
	Message() *string
}
type _UnknownOperationException struct {
	Ị_message *string `coral:"message" json:"message"`
}

func (this *_UnknownOperationException) Error() string {
	return __model__.ErrorMessage(this)
}
func (this *_UnknownOperationException) HTTPResponseCode() int {
	return 404
}
func (this *_UnknownOperationException) Message() *string {
	return this.Ị_message
}
func (this *_UnknownOperationException) SetMessage(v *string) {
	this.Ị_message = v
}
func NewUnknownOperationException() UnknownOperationException {
	return &_UnknownOperationException{}
}
func init() {
	var val UnknownOperationException
	t := __reflect__.TypeOf(&val)
	__model__.LookupService("UnknownService").Assembly("com.amazon.coral.service").RegisterShape("UnknownOperationException", t, func() interface{} {
		return NewUnknownOperationException()
	})
}

//Convenient exception that can be used when a request is aborted
//before a reply is sent back (e.g. client closed connection)
type RequestAbortedException interface {
	error
	HTTPResponseCode() int
	SetMessage(v *string)
	Message() *string
}
type _RequestAbortedException struct {
	Ị_message *string `coral:"message" json:"message"`
}

func (this *_RequestAbortedException) Error() string {
	return __model__.ErrorMessage(this)
}
func (this *_RequestAbortedException) HTTPResponseCode() int {
	return 400
}
func (this *_RequestAbortedException) Message() *string {
	return this.Ị_message
}
func (this *_RequestAbortedException) SetMessage(v *string) {
	this.Ị_message = v
}
func NewRequestAbortedException() RequestAbortedException {
	return &_RequestAbortedException{}
}
func init() {
	var val RequestAbortedException
	t := __reflect__.TypeOf(&val)
	__model__.LookupService("UnknownService").Assembly("com.amazon.coral.service").RegisterShape("RequestAbortedException", t, func() interface{} {
		return NewRequestAbortedException()
	})
}

type UnsupportedMediaTypeException interface {
	error
	HTTPResponseCode() int
	SetMessage(v *string)
	Message() *string
}
type _UnsupportedMediaTypeException struct {
	Ị_message *string `coral:"message" json:"message"`
}

func (this *_UnsupportedMediaTypeException) Error() string {
	return __model__.ErrorMessage(this)
}
func (this *_UnsupportedMediaTypeException) HTTPResponseCode() int {
	return 415
}
func (this *_UnsupportedMediaTypeException) Message() *string {
	return this.Ị_message
}
func (this *_UnsupportedMediaTypeException) SetMessage(v *string) {
	this.Ị_message = v
}
func NewUnsupportedMediaTypeException() UnsupportedMediaTypeException {
	return &_UnsupportedMediaTypeException{}
}
func init() {
	var val UnsupportedMediaTypeException
	t := __reflect__.TypeOf(&val)
	__model__.LookupService("UnknownService").Assembly("com.amazon.coral.service").RegisterShape("UnsupportedMediaTypeException", t, func() interface{} {
		return NewUnsupportedMediaTypeException()
	})
}

type AccessDeniedException interface {
	error
	HTTPResponseCode() int
	SetMessage(v *string)
	Message() *string
}
type _AccessDeniedException struct {
	Ị_Message *string `coral:"Message" json:"Message"`
}

func (this *_AccessDeniedException) Error() string {
	return __model__.ErrorMessage(this)
}
func (this *_AccessDeniedException) HTTPResponseCode() int {
	return 403
}
func (this *_AccessDeniedException) Message() *string {
	return this.Ị_Message
}
func (this *_AccessDeniedException) SetMessage(v *string) {
	this.Ị_Message = v
}
func NewAccessDeniedException() AccessDeniedException {
	return &_AccessDeniedException{}
}
func init() {
	var val AccessDeniedException
	t := __reflect__.TypeOf(&val)
	__model__.LookupService("UnknownService").Assembly("com.amazon.coral.service").RegisterShape("AccessDeniedException", t, func() interface{} {
		return NewAccessDeniedException()
	})
}

type NotAuthorizedException interface {
	error
	HTTPResponseCode() int
	SetMessage(v *string)
	Message() *string
}
type _NotAuthorizedException struct {
	Ị_Message *string `coral:"Message" json:"Message"`
}

func (this *_NotAuthorizedException) Error() string {
	return __model__.ErrorMessage(this)
}
func (this *_NotAuthorizedException) HTTPResponseCode() int {
	return 401
}
func (this *_NotAuthorizedException) Message() *string {
	return this.Ị_Message
}
func (this *_NotAuthorizedException) SetMessage(v *string) {
	this.Ị_Message = v
}
func NewNotAuthorizedException() NotAuthorizedException {
	return &_NotAuthorizedException{}
}
func init() {
	var val NotAuthorizedException
	t := __reflect__.TypeOf(&val)
	__model__.LookupService("UnknownService").Assembly("com.amazon.coral.service").RegisterShape("NotAuthorizedException", t, func() interface{} {
		return NewNotAuthorizedException()
	})
}

type DelegationException interface {
	error
	HTTPResponseCode() int
	SetMessage(v *string)
	Message() *string
}
type _DelegationException struct {
	Ị_message *string `coral:"message" json:"message"`
}

func (this *_DelegationException) Error() string {
	return __model__.ErrorMessage(this)
}
func (this *_DelegationException) HTTPResponseCode() int {
	return 500
}
func (this *_DelegationException) Message() *string {
	return this.Ị_message
}
func (this *_DelegationException) SetMessage(v *string) {
	this.Ị_message = v
}
func NewDelegationException() DelegationException {
	return &_DelegationException{}
}
func init() {
	var val DelegationException
	t := __reflect__.TypeOf(&val)
	__model__.LookupService("UnknownService").Assembly("com.amazon.coral.service").RegisterShape("DelegationException", t, func() interface{} {
		return NewDelegationException()
	})
}

type RequestTimeoutException interface {
	error
	HTTPResponseCode() int
	SetMessage(v *string)
	Message() *string
}
type _RequestTimeoutException struct {
	Ị_Message *string `coral:"Message" json:"Message"`
}

func (this *_RequestTimeoutException) Error() string {
	return __model__.ErrorMessage(this)
}
func (this *_RequestTimeoutException) HTTPResponseCode() int {
	return 408
}
func (this *_RequestTimeoutException) Message() *string {
	return this.Ị_Message
}
func (this *_RequestTimeoutException) SetMessage(v *string) {
	this.Ị_Message = v
}
func NewRequestTimeoutException() RequestTimeoutException {
	return &_RequestTimeoutException{}
}
func init() {
	var val RequestTimeoutException
	t := __reflect__.TypeOf(&val)
	__model__.LookupService("UnknownService").Assembly("com.amazon.coral.service").RegisterShape("RequestTimeoutException", t, func() interface{} {
		return NewRequestTimeoutException()
	})
}

type InternalFailure interface {
	error
	HTTPResponseCode() int
	SetMessage(v *string)
	Message() *string
}
type _InternalFailure struct {
	Ị_message *string `coral:"message" json:"message"`
}

func (this *_InternalFailure) Error() string {
	return __model__.ErrorMessage(this)
}
func (this *_InternalFailure) HTTPResponseCode() int {
	return 500
}
func (this *_InternalFailure) Message() *string {
	return this.Ị_message
}
func (this *_InternalFailure) SetMessage(v *string) {
	this.Ị_message = v
}
func NewInternalFailure() InternalFailure {
	return &_InternalFailure{}
}
func init() {
	var val InternalFailure
	t := __reflect__.TypeOf(&val)
	__model__.LookupService("UnknownService").Assembly("com.amazon.coral.service").RegisterShape("InternalFailure", t, func() interface{} {
		return NewInternalFailure()
	})
}

type TimeoutException interface {
	error
	HTTPResponseCode() int
	SetMessage(v *string)
	Message() *string
}
type _TimeoutException struct {
	Ị_message *string `coral:"message" json:"message"`
}

func (this *_TimeoutException) Error() string {
	return __model__.ErrorMessage(this)
}
func (this *_TimeoutException) HTTPResponseCode() int {
	return 500
}
func (this *_TimeoutException) Message() *string {
	return this.Ị_message
}
func (this *_TimeoutException) SetMessage(v *string) {
	this.Ị_message = v
}
func NewTimeoutException() TimeoutException {
	return &_TimeoutException{}
}
func init() {
	var val TimeoutException
	t := __reflect__.TypeOf(&val)
	__model__.LookupService("UnknownService").Assembly("com.amazon.coral.service").RegisterShape("TimeoutException", t, func() interface{} {
		return NewTimeoutException()
	})
}

type ServiceUnavailableException interface {
	error
	HTTPResponseCode() int
	SetMessage(v *string)
	Message() *string
}
type _ServiceUnavailableException struct {
	Ị_Message *string `coral:"Message" json:"Message"`
}

func (this *_ServiceUnavailableException) Error() string {
	return __model__.ErrorMessage(this)
}
func (this *_ServiceUnavailableException) HTTPResponseCode() int {
	return 503
}
func (this *_ServiceUnavailableException) Message() *string {
	return this.Ị_Message
}
func (this *_ServiceUnavailableException) SetMessage(v *string) {
	this.Ị_Message = v
}
func NewServiceUnavailableException() ServiceUnavailableException {
	return &_ServiceUnavailableException{}
}
func init() {
	var val ServiceUnavailableException
	t := __reflect__.TypeOf(&val)
	__model__.LookupService("UnknownService").Assembly("com.amazon.coral.service").RegisterShape("ServiceUnavailableException", t, func() interface{} {
		return NewServiceUnavailableException()
	})
}

type UnknownService interface {
	UnknownOperation() error
}
