package com_amazon_quickbeamadmincoralservice

import (
	__client__ "CoralGoClient/client"
	__dialer__ "CoralGoClient/dialer"
	__codec__ "CoralGoCodec/codec"
)

type QuickbeamAdminCoralServiceClient struct {
	C __client__.Client
}

//Creates a new QuickbeamAdminCoralServiceClient
func NewQuickbeamAdminCoralServiceClient(dialer __dialer__.Dialer, codec __codec__.RoundTripper, options ...__client__.Option) (service *QuickbeamAdminCoralServiceClient) {
	return &QuickbeamAdminCoralServiceClient{__client__.NewClient("com.amazon.quickbeamadmincoralservice", "QuickbeamAdminCoralService", dialer, codec, options...)}
}
func (this *QuickbeamAdminCoralServiceClient) DeauthorizeAccount(input DeauthorizeAccountRequest, options ...__client__.RequestOption) error {
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "DeauthorizeAccount", input, nil, options...)
	return err
}
func (this *QuickbeamAdminCoralServiceClient) GetCertificateWithPK(input GetCertificateWithPKRequest, options ...__client__.RequestOption) (GetCertificateWithPKResponse, error) {
	var output GetCertificateWithPKResponse
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "GetCertificateWithPK", input, &output, options...)
	return output, err
}
func (this *QuickbeamAdminCoralServiceClient) PivotCertificate(input PivotCertificateRequest, options ...__client__.RequestOption) error {
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "PivotCertificate", input, nil, options...)
	return err
}
func (this *QuickbeamAdminCoralServiceClient) AddDomainToWhitelist(input AddDomainToWhitelistRequest, options ...__client__.RequestOption) error {
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "AddDomainToWhitelist", input, nil, options...)
	return err
}
func (this *QuickbeamAdminCoralServiceClient) RemoveCertificateRelation(input RemoveCertificateRelationRequest, options ...__client__.RequestOption) error {
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "RemoveCertificateRelation", input, nil, options...)
	return err
}
func (this *QuickbeamAdminCoralServiceClient) RequestLimitIncrease(input RequestLimitIncreaseRequest, options ...__client__.RequestOption) (RequestLimitIncreaseResponse, error) {
	var output RequestLimitIncreaseResponse
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "RequestLimitIncrease", input, &output, options...)
	return output, err
}
func (this *QuickbeamAdminCoralServiceClient) MigrateAccount(input MigrateAccountRequest, options ...__client__.RequestOption) error {
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "MigrateAccount", input, nil, options...)
	return err
}
func (this *QuickbeamAdminCoralServiceClient) AddDomainToBlacklist(input AddDomainToBlacklistRequest, options ...__client__.RequestOption) error {
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "AddDomainToBlacklist", input, nil, options...)
	return err
}
func (this *QuickbeamAdminCoralServiceClient) ListBlacklistDomains(input ListBlacklistDomainsRequest, options ...__client__.RequestOption) (ListBlacklistDomainsResponse, error) {
	var output ListBlacklistDomainsResponse
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "ListBlacklistDomains", input, &output, options...)
	return output, err
}
func (this *QuickbeamAdminCoralServiceClient) ListWhitelistDomains(input ListWhitelistDomainsRequest, options ...__client__.RequestOption) (ListWhitelistDomainsResponse, error) {
	var output ListWhitelistDomainsResponse
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "ListWhitelistDomains", input, &output, options...)
	return output, err
}
func (this *QuickbeamAdminCoralServiceClient) RekeyCertificate(input RekeyCertificateRequest, options ...__client__.RequestOption) error {
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "RekeyCertificate", input, nil, options...)
	return err
}
func (this *QuickbeamAdminCoralServiceClient) RemoveDomainFromBlacklist(input RemoveDomainFromBlacklistRequest, options ...__client__.RequestOption) error {
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "RemoveDomainFromBlacklist", input, nil, options...)
	return err
}
func (this *QuickbeamAdminCoralServiceClient) SetCertificateRelationVersion(input SetCertificateRelationVersionRequest, options ...__client__.RequestOption) error {
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "SetCertificateRelationVersion", input, nil, options...)
	return err
}
func (this *QuickbeamAdminCoralServiceClient) RetrieveAccountInfo(input RetrieveAccountInfoRequest, options ...__client__.RequestOption) (RetrieveAccountInfoResponse, error) {
	var output RetrieveAccountInfoResponse
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "RetrieveAccountInfo", input, &output, options...)
	return output, err
}
func (this *QuickbeamAdminCoralServiceClient) CreateCertificateRelation(input CreateCertificateRelationRequest, options ...__client__.RequestOption) (CreateCertificateRelationResponse, error) {
	var output CreateCertificateRelationResponse
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "CreateCertificateRelation", input, &output, options...)
	return output, err
}
func (this *QuickbeamAdminCoralServiceClient) RevokeCertificate(input RevokeCertificateRequest, options ...__client__.RequestOption) (RevokeCertificateResponse, error) {
	var output RevokeCertificateResponse
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "RevokeCertificate", input, &output, options...)
	return output, err
}
func (this *QuickbeamAdminCoralServiceClient) SetAccountLimits(input SetAccountLimitsRequest, options ...__client__.RequestOption) error {
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "SetAccountLimits", input, nil, options...)
	return err
}
func (this *QuickbeamAdminCoralServiceClient) RenewCertificate(input RenewCertificateRequest, options ...__client__.RequestOption) error {
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "RenewCertificate", input, nil, options...)
	return err
}
func (this *QuickbeamAdminCoralServiceClient) ArchiveCertificate(input ArchiveCertificateRequest, options ...__client__.RequestOption) error {
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "ArchiveCertificate", input, nil, options...)
	return err
}
func (this *QuickbeamAdminCoralServiceClient) RemoveDomainFromWhitelist(input RemoveDomainFromWhitelistRequest, options ...__client__.RequestOption) error {
	err := this.C.Call("com.amazon.quickbeamadmincoralservice", "RemoveDomainFromWhitelist", input, nil, options...)
	return err
}
