package main

import (
	"CoralGoClient/dialer"
	"CoralRPCGoSupport/rpcv1"
	"authv4"
	av4creds "authv4/credentials"
	quickbeam "com/amazon/quickbeamadmincoralservice"
	"crypto/tls"
	"fmt"

	"github.com/aws/aws-sdk-go/aws/credentials"
)

type SDKCredsWrapper struct {
	sdkcreds *credentials.Credentials
}

func (c *SDKCredsWrapper) Get() (av4creds.Value, error) {
	creds, e := c.sdkcreds.Get()
	return av4creds.Value{creds.AccessKeyID, creds.SecretAccessKey, creds.SessionToken}, e
}

func main() {

	creds := credentials.NewEnvCredentials()

	QuickbeamSigner := authv4.NewSignerWithCreds("us-east-1", "acm", &SDKCredsWrapper{creds}, nil)
	QuickbeamHost := "acm-internal.us-east-1.amazonaws.com"
	quickbeamCodec := rpcv1.New(QuickbeamHost, rpcv1.SetSignerV4(QuickbeamSigner))
	QuickbeamDialer, err := dialer.TLS(QuickbeamHost, 443, &tls.Config{
		InsecureSkipVerify: true,
	})
	if err != nil {
		panic(fmt.Sprintf("Unable to set up TLS connection to QUICKBEAM: %s,", err))
	}
	client := quickbeam.NewQuickbeamAdminCoralServiceClient(QuickbeamDialer, quickbeamCodec)
	fmt.Printf("%+v", client)
}
