/* Copyright 2017 Amazon.com, Inc. or its affiliates. All Rights Reserved. */
package aaa

import "testing"

func TestToAuthorizationCode(t *testing.T) {
	tests := []struct {
		value    string
		expected AuthorizationCode
	}{
		{"", AuthorizationCodeNone},
		{"blarg", AuthorizationCodeNone},
		{"Authorized", AuthorizationCodeAuthorized},
		{"authorized", AuthorizationCodeAuthorized},
		{"AUTHORIZED", AuthorizationCodeAuthorized},
		{"Denied", AuthorizationCodeDenied},
		{"deNied", AuthorizationCodeDenied},
		{"DENIED", AuthorizationCodeDenied},
		{"PassThrough", AuthorizationCodePassThrough},
		{"passthrough", AuthorizationCodePassThrough},
		{"PASS_THROUGH", AuthorizationCodePassThrough},
	}

	for _, test := range tests {
		if ac := ToAuthorizationCode(test.value); ac != test.expected {
			t.Error("Expected", test.expected, "for string", test.value, "but got", ac)
		}
	}
}
