package client

import (
	"CoralGoCodec/codec"
	"errors"
)

// RequestOption is a configuration function that can be passed to the Call function in order to customize codec.Request.
// RequestOption will be applied during the Call function execution.
// A function should return a non-nil error if the request option cannot be applied
type RequestOption func(r *codec.Request) error

// WithCustomHeaders allows to set custom Headers for a codec.Request.
// WithCustomHeaders returns an error if codec.Request is nil.
func WithCustomHeaders(requestHeaders map[string]string) RequestOption {
	return func(r *codec.Request) error {
		if r == nil {
			return errors.New("codec.Request cannot be nil")
		}
		if r.RequestHeaders == nil {
			r.RequestHeaders = make(map[string]string)
		}
		for k, v := range requestHeaders {
			r.RequestHeaders[k] = v
		}
		return nil
	}
}
