package coral

import (
	"coral/shape"
	"errors"
)

type Assembly struct {
	Namespace string
	Shapes    []shape.Interface
	Services  []shape.Service
}

func (asm Assembly) LookupShape(name string) (shape.Interface, error) {
	for _, shape := range asm.Shapes {
		if shape.Name().Name() == name {
			return shape, nil
		}
	}
	return nil, errors.New("No shape found for name " + name)
}

type Assemblies []Assembly

func (asms Assemblies) LookupShape(ref shape.Reference) (shape.Interface, error) {
	for _, asm := range asms {
		if asm.Namespace == ref.Assembly() {
			shape.ReferenceMatchedAssemblyMap[ref] = ref.Assembly()
			return asm.LookupShape(ref.Name())
		}
	}

	// If this point is reached, we couldn't match the shape reference's parsed assembly name to an assembly directly.
	// Fall back to comparing against the shape reference's fileAssembly name, which came from the assembly definition
	// in which the shape was originally found.
	for _, asm := range asms {
		if asm.Namespace == ref.FileAssembly() {
			shape.ReferenceMatchedAssemblyMap[ref] = ref.FileAssembly()
			return asm.LookupShape(ref.Name())
		}
	}

	return nil, errors.New("No assembly found for namespace " + ref.Assembly())
}
