package encoding

import (
	coral "coral/assembly"
	"coral/shape"
	"io"
)

type Decoder interface {
	//Decode a slice of readers into a slice of Assemblies
	Decode([]io.Reader) coral.Assemblies
}

type Encoder interface {
	//Encode the assembly into a map of file paths to file contents
	Encode(coral.Assembly, coral.Assemblies, []shape.Service) map[string]string
}

type DecoderFunc func([]io.Reader) coral.Assemblies

func (f DecoderFunc) Decode(rdrs []io.Reader) coral.Assemblies {
	return f(rdrs)
}

type EncoderFunc func(coral.Assembly, coral.Assemblies) map[string]string

func (f EncoderFunc) Encode(asm coral.Assembly, asms coral.Assemblies) map[string]string {
	return f(asm, asms)
}
