package golang

import (
	"strings"
)

func (f *assemblyFile) path() string {
	_, path := parseAssembly(f.asm.Namespace)
	return path
}

func (f *assemblyFile) pkg() string {
	pkg, _ := parseAssembly(f.asm.Namespace)
	return pkg
}

func parseAssembly(assembly string) (packageName string, importPath string) {
	pkgs := strings.Split(assembly, ".")
	if len(pkgs) == 1 {
		importPath = pkgs[0]
		packageName = pkgs[0]
		return
	}
	packageName = strings.Join(pkgs, "_")
	importPath = strings.Join(pkgs, "/")
	return
}
