package golang

import (
	"coral/shape"
	"go/ast"
	"go/token"
)

var __model__ model

type model struct{}

func (model) LookupService(name string) *ast.CallExpr {
	return &ast.CallExpr{
		Fun: ast.NewIdent("__model__.LookupService"),
		Args: []ast.Expr{
			&ast.BasicLit{
				Kind:  token.STRING,
				Value: `"` + name + `"`,
			},
		},
	}
}
func (model) Assembly(name string) *ast.CallExpr {
	return &ast.CallExpr{
		Fun: ast.NewIdent("Assembly"),
		Args: []ast.Expr{
			&ast.BasicLit{
				Kind:  token.STRING,
				Value: `"` + name + `"`,
			},
		},
	}
}

func (model) RegisterShape(shape string, t string, constructor *ast.FuncLit) *ast.CallExpr {
	return &ast.CallExpr{
		Fun: ast.NewIdent("RegisterShape"),
		Args: []ast.Expr{
			&ast.BasicLit{
				Kind:  token.STRING,
				Value: `"` + shape + `"`,
			},
			ast.NewIdent(t),
			constructor,
		},
	}
}

func (model) RegisterOp(shape string, input, output shape.Reference, errs []shape.Reference) *ast.CallExpr {
	nilIdent := ast.NewIdent("nil")
	inputIdent := nilIdent
	if input != nil {
		inputIdent = ast.NewIdent("input")
	}
	outputIdent := nilIdent
	if output != nil {
		outputIdent = ast.NewIdent("output")
	}
	errsIdent := nilIdent
	return &ast.CallExpr{
		Fun: ast.NewIdent("RegisterOp"),
		Args: []ast.Expr{
			&ast.BasicLit{
				Kind:  token.STRING,
				Value: `"` + shape + `"`,
			},
			inputIdent,
			outputIdent,
			errsIdent,
		},
	}
}

func (model) ErrorMessage(name string) *ast.CallExpr {
	return &ast.CallExpr{
		Fun:  ast.NewIdent("__model__.ErrorMessage"),
		Args: []ast.Expr{ast.NewIdent(name)},
	}
}
