package golang

import (
	"coral/shape"
	"strings"
)

//ptrIdent creates an identifier which points to the reference
func (f *assemblyFile) ptrIdent(r shape.Reference) string {
	i := f.publicIdent(r)
	return "*" + i
}

//factoryIdent creates an identifier which is the name of the function that is used to create a new instance of the reference
func (f *assemblyFile) factoryIdent(r shape.Reference) string {
	return f.createIdent(r, func(s string) string {
		return "New" + capitalCase(s)
	})
}

//publicIdent creates an identifier which is the name of the public type of the reference
func (f *assemblyFile) publicIdent(r shape.Reference) string {
	return f.createIdent(r, capitalCase)
}

//privateIdent creates an identifier which is the private type of the reference
func (f *assemblyFile) privateIdent(r shape.Reference) string {
	return "_" + f.createIdent(r, capitalCase)
}

//createIdent creates an identifier based off of the shape and namer function
func (f *assemblyFile) createIdent(r shape.Reference, namer func(string) string) string {
	var pkg string

	refMatchedAssembly := shape.ReferenceMatchedAssemblyMap[r]

	if f.nativeType(r) == nil && refMatchedAssembly != "" && f.asm.Namespace != refMatchedAssembly {
		var path string
		pkg, path = parseAssembly(refMatchedAssembly)
		f.externAsms[pkg] = path
		pkg = pkg + "."
	}
	return pkg + namer(r.Name())
}

func camelCase(s string) string {
	if len(s) == 0 {
		return s
	}
	return strings.ToLower(s[:1]) + s[1:]
}

func capitalCase(s string) string {
	if len(s) == 0 {
		return s
	}
	return strings.ToUpper(s[:1]) + s[1:]
}
