package golang

import (
	"go/ast"
)

var __reflect__ reflect

type reflect struct{}

func (reflect) TypeOf(name string) *ast.CallExpr {
	return &ast.CallExpr{
		Fun: ast.NewIdent("__reflect__.TypeOf"),
		Args: []ast.Expr{
			pointerTo(ast.NewIdent(name)),
		},
	}
}

func (reflect) Value(names ...string) *ast.Field {
	var idents []*ast.Ident = nil
	if len(names) > 0 {
		idents = make([]*ast.Ident, len(names))
		for i, name := range names {
			idents[i] = ast.NewIdent(name)
		}
	}
	return &ast.Field{
		Type:  ast.NewIdent("__reflect__.Value"),
		Names: idents,
	}
}

func (reflect) ValueOf(name string) *ast.CallExpr {
	return &ast.CallExpr{
		Fun:  ast.NewIdent("__reflect__.ValueOf"),
		Args: []ast.Expr{ast.NewIdent(name)},
	}
}
