package xml

import (
	"fmt"
	"reflect"
	"sort"
)

type Unique interface {
	Unique() string
}

var uniqueType reflect.Type

func init() {
	uniqueType = reflect.TypeOf((*Unique)(nil)).Elem()
}

type sortSlice struct {
	value interface{}
}

func (this sortSlice) Less(i, j int) bool {
	v := reflect.ValueOf(this.value)
	uniqueI := v.Index(i).Interface().(Unique)
	uniqueJ := v.Index(j).Interface().(Unique)
	return uniqueLess(uniqueI, uniqueJ)
}

func (this sortSlice) Swap(i, j int) {
	val := reflect.ValueOf(this.value)
	t := reflect.TypeOf(this.value).Elem()
	tmp := reflect.New(t).Elem()
	tmp.Set(val.Index(i))
	val.Index(i).Set(val.Index(j))
	val.Index(j).Set(tmp)
}

func (this sortSlice) Len() int {
	return reflect.ValueOf(this.value).Len()
}

func isSortable(s interface{}) bool {
	t := reflect.TypeOf(s)
	isSlice := t.Kind() == reflect.Slice
	isUnique := t.Elem().Implements(uniqueType)
	return isSlice && isUnique
}

func Sort(slice interface{}) {
	if isSortable(slice) {
		sort.Sort(sortSlice{slice})
	} else {
		panic(fmt.Errorf("%T is not sortable", slice))
	}
}

func uniqueLess(i Unique, j Unique) bool { return i.Unique() < j.Unique() }
