package shape

type Structure struct {
	shape
	Members     map[string]StructureMember
	Abstract    bool
	IsA         *Reference
	IsException bool
}

type StructureMember struct {
	Reference
	Doc string
}

type List struct {
	shape
	Member Reference
}

type Map struct {
	shape
	Key   Reference
	Value Reference
}

func NewMap(name Reference) *Map {
	return &Map{shape: shape{name: name}}
}

func NewStructure(name Reference) *Structure {
	return &Structure{shape: shape{name: name}, Members: make(map[string]StructureMember, 0)}
}

func NewList(name Reference) *List {
	return &List{shape: shape{name: name}}
}
func IsComplex(shape Interface) bool {
	switch shape.(type) {
	case *Structure, *Map, *List:
		return true
	}
	return false
}
