package shape

var ReferenceMatchedAssemblyMap = map[Reference]string{}

type Reference interface {
	FileAssembly() string
	Assembly() string
	Name() string
}

type MemberReference interface {
	Reference
	Member() string
}

type reference struct {
	fileAssembly string
	assembly     string
	name         string
}

type memberReference struct {
	reference
	member string
}

func (r reference) Assembly() string {
	return r.assembly
}

func (r reference) Name() string {
	return r.name
}

func (r reference) FileAssembly() string {
	return r.fileAssembly
}

func (r memberReference) Member() string {
	return r.member
}

func NewReference(fileAsm, asm, name string) Reference {
	return reference{fileAsm, asm, name}
}

func NewMemberReference(fileAsm, asm, name, member string) MemberReference {
	return memberReference{reference{fileAsm, asm, name}, member}
}
