package shape

type Service struct {
	shape
	Operations []*Operation
}

func NewService(name Reference) *Service {
	return &Service{
		shape{name: name},
		make([]*Operation, 0),
	}
}

type Operation struct {
	shape
	Input     Reference
	Output    Reference
	Errors    []Reference
	Services  []Reference
	Endpoints []RestEndpoint
}

func NewOperation(name Reference) *Operation {
	return &Operation{
		shape{name: name},
		nil,
		nil,
		make([]Reference, 0),
		make([]Reference, 0),
		make([]RestEndpoint, 0),
	}
}

// RestEndpoint corresponds to the HTTP Coral trait.
type RestEndpoint struct {
	// HTTP method, e.g GET, POST, PUT, or DELETE.
	Verb string
	// Relative path.
	Uri string
}
