package shape

type Interface interface {
	Name() Reference //The name of the shape
	Doc() string     //Documentation
	SetDoc(string)
}

type shape struct {
	name Reference
	doc  string
}

func (s *shape) SetDoc(doc string) {
	s.doc = doc
}

func (s *shape) Name() Reference {
	return s.name
}

func (s *shape) Doc() string {
	return s.doc
}

type (
	Boolean struct {
		shape
	}
	Byte struct {
		shape
	}
	Timestamp struct {
		shape
	}
	Character struct {
		shape
	}
	Double struct {
		shape
	}
	Float struct {
		shape
	}
	Integer struct {
		shape
	}
	Long struct {
		shape
	}
	Short struct {
		shape
	}
	Blob struct {
		shape
	}
	BigInteger struct {
		shape
	}
	BigDecimal struct {
		shape
	}
	Envelope struct {
		shape
	}
)

func NewBoolean(name Reference) *Boolean {
	return &Boolean{
		shape{name: name},
	}
}

func NewByte(name Reference) *Byte {
	return &Byte{
		shape{name: name},
	}
}

func NewTimestamp(name Reference) *Timestamp {
	return &Timestamp{
		shape{name: name},
	}
}

func NewCharacter(name Reference) *Character {
	return &Character{

		shape{name: name},
	}
}

func NewDouble(name Reference) *Double {
	return &Double{
		shape{name: name},
	}
}

func NewFloat(name Reference) *Float {
	return &Float{
		shape{name: name},
	}
}

func NewInteger(name Reference) *Integer {
	return &Integer{
		shape{name: name},
	}
}

func NewLong(name Reference) *Long {
	return &Long{
		shape{name: name},
	}
}

func NewShort(name Reference) *Short {
	return &Short{
		shape{name: name},
	}
}

func NewBlob(name Reference) *Blob {
	return &Blob{
		shape{name: name},
	}
}

func NewBigInteger(name Reference) *BigInteger {
	return &BigInteger{
		shape{name: name},
	}
}

func NewBigDecimal(name Reference) *BigDecimal {
	return &BigDecimal{
		shape{name: name},
	}
}

func NewEnvelope(name Reference) *Envelope {
	return &Envelope{
		shape{name: name},
	}
}

func IsSimple(value Interface) bool {
	switch value.(type) {
	case *Boolean, *Byte, *Timestamp, *Character, *Double, *Float, *Integer,
		*Long, *Short, *String, *Blob, *BigInteger, *BigDecimal, *Envelope:
		return true
	}
	return false
}
