package shape

func NewString(name Reference) *String {
	return NewStringWithEncoding(name, UTF8)
}

func NewStringWithEncoding(name Reference, encoding Encoding) *String {
	return &String{
		shape:    shape{name: name},
		Encoding: encoding,
	}
}

type String struct {
	shape
	Encoding
}

type Encoding int

const (
	UTF8 Encoding = iota
)
