package main

import (
	"brazilpath"
	"coral/driver"
	"coral/encoding/golang"
	"coral/encoding/xml"
	"flag"
)

var (
	flagCompile = flag.Bool("compile", true, "Set to false to disable compiling after model generation")
)

func main() {
	pkgName, err := brazilpath.PackageName()
	if err != nil {
		panic(err)
	}
	flag.Parse()
	driver.Exec(xml.Decoder, golang.ModelEncoder{PkgName: pkgName}, *flagCompile)
}
