/* Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

// Package awsjsonv1 provides client and server support for the AWS JSON v1.0
// wire format.  AWS JSON 1.0 is a variant of Coral RPC v1 with the differences
// being:
//   * The Content-Type is "application/x-amz-json-1.0" rather than "application/json"
//   * The X-Amz-Target header value as well as all of the "__type" values are not
//     qualified with a namespace/assembly, e.g AWS JSON uses "ServiceName.Operation"
//     and "ServiceName#Type" where Coral RPC uses "Namespace.ServiceName.Operation"
//     and "Namespace.ServiceName#Type.
//
// While much of the code could be the same between the two implementations, only
// the RoundTrip implementation and usage of the custom json package is currently shared.
package awsjsonv1
