/* Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

package roundtrip

import "fmt"

// Ensure that our Error type satisfies the error interface.
var _ error = &Error{}

// Custom error type that provides additional information about the context
// of the request.
type Error struct {
	Context
	cause   error
	message string
}

// NewError creates a new roundtrip.Error with the given cause and Context.
func NewError(message string, cause error, context Context) *Error {
	return &Error{
		Context: context,
		cause:   cause,
		message: message,
	}
}

// Error satisfies the error interface.
func (e Error) Error() string {
	return fmt.Sprintf("%s: %v", e.message, e.cause)
}

// Cause returns the underlying cause of the error.
// This is the same Cause interface in the github.com/pkg/errors package.
func (e Error) Cause() error {
	return e.cause
}
