/* Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

package roundtrip

import (
	"CoralGoCodec/codec"
	"errors"
	"reflect"
	"testing"
)

func TestNewRoundTripError(t *testing.T) {
	cause := errors.New("cause")
	reqID := "foo"
	respStatusCode := 200
	ctx := Context{
		Request:            &codec.Request{},
		RequestID:          reqID,
		ResponseStatusCode: respStatusCode,
	}
	rte := NewError("msg", cause, ctx)
	if !reflect.DeepEqual(rte.Context, ctx) {
		t.Errorf("context mismatch: got: %#v, want: %#v", rte.Context, ctx)
	}
	wantError := "msg: cause"
	if got := rte.Error(); got != wantError {
		t.Errorf("error mismatch: got: %s, want: %s", got, wantError)
	}
	if got := rte.Cause(); got != cause {
		t.Errorf("cause mismatch: got: %v, want: %v", got, cause)
	}
}
