// Copyright 2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.

package rpcv0

import (
	"CoralGoCodec/codec"
	"io"
)

const (
	accept          = "application/json, text/javascript"
	contentTypeFull = "application/json; charset=UTF-8;"
)

// RoundTrip executes a send and receive of a request over the wire.
// - Request is what to encode and send over the wire.
// - rw is the transport to write the request to and read the response from.
func (c RPCv0) RoundTrip(r *codec.Request, rw io.ReadWriter) error {
	if r.RequestHeaders == nil {
		r.RequestHeaders = make(map[string]string)
	}
	r.RequestHeaders[headerAccept] = accept
	r.RequestHeaders[headerContentType] = contentTypeFull
	return c.tripper.Go(c.Path, r, rw)
}
