// Copyright 2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.

package rpcv0

import (
	"CoralRPCGoSupport/internal/test/fake"
	"testing"
)

func TestNew(t *testing.T) {
	rpc := New()

	if rpc.Path == "" {
		t.Error("expected common initializer to set Path field")
	}
}

func TestNewClientCodec(t *testing.T) {
	host := "localhost"
	fakeAAA := &fake.AAA{}
	fakeBearerTokenVendor := &fake.BearerTokenVendor{}
	fakeCloudAuth := &fake.CloudAuth{}

	rpc := NewClientCodec(
		host,
		SetAAAClient(fakeAAA),
		SetAAAForServer(fakeAAA),
		SetSignerV4(fake.Signer),
		SetARPSAuthorizer(&fake.ARPSAuthorizer),
		SetBearerTokenVendor(fakeBearerTokenVendor),
		SetCloudAuthForServer(fakeCloudAuth),
	)

	if rpc.Host != host || rpc.tripper.Host != host {
		t.Errorf("expected host to be %q but was %q and %q", host, rpc.Host, rpc.tripper.Host)
	}

	if rpc.AAAClient != fakeAAA || rpc.tripper.AAAClient != fakeAAA {
		t.Error("expected AAA client to be non nil")
	}

	if rpc.AAA != fakeAAA {
		t.Error("expected AAA to be non nil")
	}

	if rpc.SignerV4 != fake.Signer || rpc.tripper.SignerV4 != fake.Signer {
		t.Error("expected SignerV4 field to be non nil")
	}

	if rpc.ARPSAuthorizer != &fake.ARPSAuthorizer || rpc.tripper.ARPSAuthorizer != &fake.ARPSAuthorizer {
		t.Error("expected ARPSAuthorizer field to be non nil")
	}

	if rpc.bearerTokenVendor != fakeBearerTokenVendor || rpc.tripper.BearerTokenVendor != fakeBearerTokenVendor {
		t.Error("expected bearerTokenVendor field to be non nil")
	}

	if rpc.cloudAuth != fakeCloudAuth {
		t.Error("expected cloudAuth field to be non nil")
	}

	if rpc.Path != "/" {
		t.Error("expected common initializer to set Path field")
	}
}
