/* Copyright 2017 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

package rpcv1

import (
	"CoralRPCGoSupport/internal/test/fake"
	"testing"
)

func TestNew(t *testing.T) {
	// Make sure that we can construct without any options without causing a panic.
	host := "host"
	if r := New(host, nil); r.Host != host {
		t.Error("Failure to set host")
	}

	fakeAAA := &fake.AAA{}
	if r := New("", SetAAAClient(fakeAAA)); r.AAAClient != fakeAAA || r.tripper.AAAClient != fakeAAA {
		t.Error("Failure to set AAA client")
	}

	if r := New("", SetARPSAuthorizer(&fake.ARPSAuthorizer)); r.ARPSAuthorizer != &fake.ARPSAuthorizer || r.tripper.ARPSAuthorizer != &fake.ARPSAuthorizer {
		t.Error("Failure to set ARPSAuthorizer")
	}

	if r := New("", SetAAAForServer(fakeAAA)); r.AAA != fakeAAA {
		t.Error("Failure to set AAA client")
	}

	fakeBearerTokenVendor := &fake.BearerTokenVendor{}
	if r := New("", SetBearerTokenVendor(fakeBearerTokenVendor)); r.bearerTokenVendor != fakeBearerTokenVendor || r.tripper.BearerTokenVendor != fakeBearerTokenVendor {
		t.Error("Failure to set BearerTokenVendor")
	}

	fakeCloudAuth := &fake.CloudAuth{}
	if r := New("", SetCloudAuthForServer(fakeCloudAuth)); r.cloudAuth != fakeCloudAuth {
		t.Error("Failure to set CloudAuth")
	}

	path := "/path"
	if r := New("", SetPath(path)); r.Path != path {
		t.Error("Failure to set path")
	}

	if r := New("", SetSignerV4(fake.Signer)); r.SignerV4 != fake.Signer || r.tripper.SignerV4 != fake.Signer {
		t.Error("Failure to set SignerV4")
	}

	token := "token"
	if r := New("", SetSecurityToken(token)); r.SecurityToken != token || r.tripper.SecurityToken != token {
		t.Error("Failure to set security token")
	}
}
