/* Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved. */

package cloudauth

import (
	"fmt"
)

// InvalidError is generated on invalid data inputs.
type InvalidError struct {
	Type  string
	Value string
}

func (e *InvalidError) Error() string {
	if e.Value == "" {
		return "cloudauth: Invalid " + e.Type
	}

	return fmt.Sprintf("cloudauth: Invalid %s: %s", e.Type, e.Value)
}

// GeneralError is a generic error.
type GeneralError struct {
	Err error
}

func (e *GeneralError) Error() string {
	return "cloudauth: " + e.Err.Error()
}

// OAuthError is an OAuth-related error.
type OAuthError struct {
	Err error
}

func (e *OAuthError) Error() string {
	return "cloudauth: " + e.Err.Error()
}

// NoTokenError is generated when no access tokens have been obtained previously
// for a particular Resource Server
type NoTokenError struct {
	host string
}

func (e *NoTokenError) Error() string {
	return "cloudauth: No token available for " + e.host
}
