package credentials

import (
	"testing"

	"authv4/internal/test"
	"github.com/aws/aws-sdk-go/aws/credentials"
	"github.com/stretchr/testify/assert"
)

func TestInterface(t *testing.T) {
	var r Renewable
	var err error

	r, err = NewRenewable()
	assert.NoError(t, err)
	assert.NotNil(t, r)
}

func TestGet(t *testing.T) {
	r := &RenewableCredentials{
		creds: credentials.NewStaticCredentials(test.AccessKey, test.SecretKey, test.SessionToken),
	}

	v, err := r.Get()
	assert.NoError(t, err)

	assert.Equal(t, test.AccessKey, v.AccessKeyID)
	assert.Equal(t, test.SecretKey, v.SecretAccessKey)
	assert.Equal(t, test.SessionToken, v.SessionToken)
}

func TestGetError(t *testing.T) {
	r := &RenewableCredentials{
		creds: credentials.NewStaticCredentials("", "", ""),
	}

	_, err := r.Get()
	assert.Error(t, err)
}
