package credentials

// Static credentials wrapper
type Static struct {
	val *Value
}

// Provides backwards-compatibility with non-renewable credentials.
// If you need credentials to be renewable, please implement interface Renewable.
func NewStatic(accesKeyId, secretKeyId string) *Static {
	val := Value{AccessKeyID: accesKeyId, SecretAccessKey: secretKeyId}
	return &Static{&val}
}

// Just returns value
func (s *Static) Get() (Value, error) {
	return *s.val, nil
}
