package fake

import (
	"authv4/credentials"
	"authv4/internal/test"
	"errors"
)

type Credentials struct {
	FailGet        bool
	IncludeSession bool
	getCount       int
}

// this function rotates through two credentials (either with or without session token), to simulate credentials expiring and getting renewed
func (f *Credentials) Get() (credentials.Value, error) {
	if f.FailGet {
		return credentials.Value{}, errors.New("failed to get creds")
	}
	f.getCount++
	if f.getCount%2 != 0 {
		if f.IncludeSession {
			return credentials.Value{AccessKeyID: test.AccessKey, SecretAccessKey: test.SecretKey, SessionToken: test.SessionToken}, nil
		} else {
			return credentials.Value{AccessKeyID: test.AccessKey, SecretAccessKey: test.SecretKey}, nil
		}
	} else {
		if f.IncludeSession {
			return credentials.Value{AccessKeyID: test.AccessKey2, SecretAccessKey: test.SecretKey2, SessionToken: test.SessionToken2}, nil
		} else {
			return credentials.Value{AccessKeyID: test.AccessKey2, SecretAccessKey: test.SecretKey2}, nil
		}
	}
}
