/* Copyright 2016 Amazon.com, Inc. or its affiliates. All Rights Reserved. */
package level_test

import (
	"GoLog/log/level"
	"testing"
)

func TestLevelStr(t *testing.T) {
	tests := []struct {
		lvl      level.Level
		expected string
	}{
		{level.Off, ""},
		{level.Trace, "[TRACE]"},
		{level.Debug, "[DEBUG]"},
		{level.Info, "[INFO]"},
		{level.Warn, "[WARN]"},
		{level.Error, "[ERROR]"},
		{level.Fatal, "[FATAL]"},
		{level.Level(99), "[UNKNOWN]"},
	}

	for _, test := range tests {
		if val := level.LevelStr(test.lvl); val != test.expected {
			t.Error("Expected", test.expected, "but found", val, "for Level", test.lvl)
		}
	}
}

func TestFromString(t *testing.T) {
	tests := []struct {
		lvl      string
		expected level.Level
	}{
		{"OFF", level.Off},
		{"trace", level.Trace},
		{"Debug", level.Debug},
		{"INFO", level.Info},
		{"wArn", level.Warn},
		{"ERror", level.Error},
		{"fAtAl", level.Fatal},
		{"Bob", level.Off},
	}

	for _, test := range tests {
		if val := level.FromString(test.lvl); val != test.expected {
			t.Error("Expected", test.expected, "but found", val, "for string", test.lvl)
		}
	}
}
