package log

// MockAmznLogger is a mockable struct that implements the Logger interface.
type MockAmznLogger struct {
	MockTrace  func(v ...interface{})
	MockTracef func(format string, v ...interface{})
	MockTracew func(fields Fields, v ...interface{})
	MockDebug  func(v ...interface{})
	MockDebugf func(format string, v ...interface{})
	MockDebugw func(fields Fields, v ...interface{})
	MockInfo   func(v ...interface{})
	MockInfof  func(format string, v ...interface{})
	MockInfow  func(fields Fields, v ...interface{})
	MockWarn   func(v ...interface{})
	MockWarnf  func(format string, v ...interface{})
	MockWarnw  func(fields Fields, v ...interface{})
	MockError  func(v ...interface{})
	MockErrorf func(format string, v ...interface{})
	MockErrorw func(fields Fields, v ...interface{})
	MockFatal  func(v ...interface{})
	MockFatalf func(format string, v ...interface{})
	MockFatalw func(fields Fields, v ...interface{})
}

func (logger *MockAmznLogger) Trace(v ...interface{})                 { logger.MockTrace(v...) }
func (logger *MockAmznLogger) Tracef(format string, v ...interface{}) { logger.MockTracef(format, v...) }
func (logger *MockAmznLogger) Tracew(fields Fields, v ...interface{}) { logger.MockTracew(fields, v...) }
func (logger *MockAmznLogger) Debug(v ...interface{})                 { logger.MockDebug(v...) }
func (logger *MockAmznLogger) Debugf(format string, v ...interface{}) { logger.MockDebugf(format, v...) }
func (logger *MockAmznLogger) Debugw(fields Fields, v ...interface{}) { logger.MockDebugw(fields, v...) }
func (logger *MockAmznLogger) Info(v ...interface{})                  { logger.MockInfo(v...) }
func (logger *MockAmznLogger) Infof(format string, v ...interface{})  { logger.MockInfof(format, v...) }
func (logger *MockAmznLogger) Infow(fields Fields, v ...interface{})  { logger.MockInfow(fields, v...) }
func (logger *MockAmznLogger) Warn(v ...interface{})                  { logger.MockWarn(v...) }
func (logger *MockAmznLogger) Warnf(format string, v ...interface{})  { logger.MockWarnf(format, v...) }
func (logger *MockAmznLogger) Warnw(fields Fields, v ...interface{})  { logger.MockWarnw(fields, v...) }
func (logger *MockAmznLogger) Error(v ...interface{})                 { logger.MockError(v...) }
func (logger *MockAmznLogger) Errorf(format string, v ...interface{}) { logger.MockErrorf(format, v...) }
func (logger *MockAmznLogger) Errorw(fields Fields, v ...interface{}) { logger.MockErrorw(fields, v...) }
func (logger *MockAmznLogger) Fatal(v ...interface{})                 { logger.MockFatal(v...) }
func (logger *MockAmznLogger) Fatalf(format string, v ...interface{}) { logger.MockFatalf(format, v...) }
func (logger *MockAmznLogger) Fatalw(fields Fields, v ...interface{}) { logger.MockFatalw(fields, v...) }
