# instance inside the public subnet
resource "aws_instance" "bastion" {
  ami                         = "${var.bastion_ami_id}"
  instance_type               = "t2.medium"
  subnet_id                   = "${aws_subnet.public-1.id}"
  vpc_security_group_ids      = ["${aws_security_group.public-sg.id}"]
  associate_public_ip_address = true
  source_dest_check           = false
  user_data                   = "${file("./bootstrap/add-keys.sh")}"

  tags = "${merge(
    local.common_tags,
    map(
      "Name", "${var.vpc_name}-bastion"
    )
  )}"
}

output "bastion Public IP" {
  value = "${aws_instance.bastion.public_ip}"
}
