import sys
import io
import os

from consul_monitor_analyzer import ConsulMonitorAnalyzer

dir_path = os.path.dirname(os.path.realpath(__file__))

SAMPLE_DIR = os.path.join(dir_path, 'samples')
TELEMETRY_INTERVAL = 10


def correct_path(file: str) -> str:
    return os.path.join(SAMPLE_DIR, file)


class TestConsulMonitorAnalyzer(object):
    """"""

    def setup_class(self):
        self.cma = ConsulMonitorAnalyzer()
        self.cma.parse_files(correct_path('testdir'))

    def test_summary(self, capsys):

        self.cma.summary()
        out, _ = capsys.readouterr()

        with open(correct_path('expected_output/summary.txt')) as f:
            content = f.readlines()

        assert out == ''.join(content)


class TestConsulMonitorAnalyzerDetailed(object):
    """"""

    def setup_class(self):
        self.cma = ConsulMonitorAnalyzer(detailed=True)
        self.cma.parse_files(correct_path('testdir'))

    def test_summary(self, capsys):

        self.cma.summary()
        out, _ = capsys.readouterr()

        with open(correct_path('expected_output/summary_detailed.txt')) as f:
            content = f.readlines()

        assert out == ''.join(content)


class TestConsulMonitorAnalyzerPipe(object):
    """"""

    def setup_class(self):
        self.cma = ConsulMonitorAnalyzer(interval=TELEMETRY_INTERVAL)

    def test_http_pipe(self, capsys):
        with open(correct_path('testdir/consul-master-a24e0c.sjc02.justin.tv.consul.monitor.log')) as f:
            content = f.readlines()

        sys.stdin = io.StringIO(''.join(content))
        self.cma.pipe_input(calltype='http')
        out, _ = capsys.readouterr()

        with open(correct_path('expected_output/pipe-http-10s.txt')) as f:
            content = f.readlines()

        assert out == ''.join(content)

    def test_telemetry(self, capsys):
        with open(correct_path('consul-error.log')) as f:
            content = f.readlines()

        sys.stdin = io.StringIO(''.join(content))
        self.cma.pipe_input(calltype='rpc')
        out, _ = capsys.readouterr()

        with open(correct_path('expected_output/pipe-telemetry.txt')) as f:
            content = f.readlines()

        assert out == ''.join(content)
