#!/bin/bash

[[ "$EUID" -ne 0 ]] && echo "This script must be run as root" && exit 1

apt-get update
apt-get -y install htop iftop iotop jq awscli
apt-get -y install python3-boto3 python3-pip && pip3 install locust

# consul testing terraform module installs supervisor pypi package
# the latest pypi package does not include a default supervisord.conf by default.
# the installation instructions at http://supervisord.org say you have to make
# default supervisord.conf by using echo_supervisord_conf
#
# the consul testing terraform module has a bootstrapping script that runs
# sed on the supervisord.conf file.  these commands put the supervisord.conf file where
# the bootstrapping script expects it
pip3 install supervisor
mkdir /etc/supervisor
/usr/local/bin/echo_supervisord_conf > /etc/supervisor/supervisord.conf

# Bump file limits to 200k. This is currently what is set on consul-masters/pop-masters
sed -i '/loglevel=info/a minfds=200000 ; Bump consul open fd limit' /etc/supervisor/supervisord.conf

cat <<EOT >> /etc/supervisor/supervisord.conf
[include]
files = conf.d/*.conf
EOT
