resource "aws_s3_bucket" "configs" {
  bucket = "tf-io-consul-chaos-${var.vpc_name}"
  acl    = "private"

  # Make sure we do not destroy configs
  force_destroy = false

  tags = "${local.common_tags}"
}

resource "aws_s3_bucket_public_access_block" "block_public_access_configs" {
  bucket = "${aws_s3_bucket.configs.id}"

  block_public_acls       = true
  block_public_policy     = true
  ignore_public_acls      = true
  restrict_public_buckets = true
}

resource "aws_s3_bucket_object" "locustfile_py" {
  bucket = "${aws_s3_bucket.configs.bucket}"
  key    = "loadgen/locustfile.py"
  source = "files/loadgen/locustfile.py"
  etag   = "${md5(file("files/loadgen/locustfile.py"))}"
}

resource "aws_s3_bucket_object" "runtest_py" {
  bucket = "${aws_s3_bucket.configs.bucket}"
  key    = "loadgen/runTest.py"
  source = "files/loadgen/runTest.py"
  etag   = "${md5(file("files/loadgen/runTest.py"))}"
}

resource "aws_s3_bucket_object" "consul_monitor_analyzer_py" {
  bucket = "${aws_s3_bucket.configs.bucket}"
  key    = "loadgen/consul_monitor_analyzer.py"
  source = "benchmark/consul_monitor_analyzer.py"
  etag   = "${md5(file("benchmark/consul_monitor_analyzer.py"))}"
}

output "s3_bucket_notice" {
  value = <<EOF
Notice: If project is destroyed, S3 bucket ${aws_s3_bucket.configs.bucket}"
will not be automatically be destroyed. This has to be manually cleaned up!"

To initiate test, cp test.json to the S3 bucket:
  aws s3 cp files/test.json s3://${aws_s3_bucket.configs.bucket}/test.json
EOF
}
