#!/bin/bash
# This script is meant to be run in the User Data of each EC2 Instance while it's booting. The script uses the
# run-consul script to configure and start Consul in client mode. Note that this script assumes it's running in an AMI
# built from the Packer template in examples/consul-ami/consul.json.

set -x

# These variables are passed in via Terraform template interplation
/opt/consul/bin/run-consul --client --cluster-tag-key "${cluster_tag_key}" --cluster-tag-value "${cluster_tag_value}" --datacenter "${cluster_tag_value}"

pip3 install --user --upgrade awscli
pip3 install --user --upgrade boto3

# You could add commands to boot your other apps here
mkdir -p /opt/loadgen
aws s3 sync "s3://${s3_bucket}/loadgen/" /opt/loadgen/
python3 -c 'import pkg_resources; f = open("/tmp/boto3_version", "w"); boto3_version = (pkg_resources.get_distribution("boto3").version); f.write(boto3_version + "\n"); f.close()'

# Poor man's method to keep this running
nohup bash -c "
while : ; do
    python3 /opt/loadgen/runTest.py '${s3_bucket}'
    echo 'Unexpected death.. Restarting..'
    sleep 5
done" &> /var/log/loadgen.log &
