#!/bin/bash
# This script is meant to be run in the User Data of each EC2 Instance while it's booting. The script uses the
# run-consul script to configure and start Consul in server mode. Note that this script assumes it's running in an AMI
# built from the Packer template in examples/consul-ami/consul.json.

set -x

# These variables are passed in via Terraform template interplation
/opt/consul/bin/run-consul --server --cluster-tag-key "${cluster_tag_key}" --cluster-tag-value "${cluster_tag_value}" --datacenter "${cluster_tag_value}"

pip3 install --user --upgrade awscli
pip3 install --user --upgrade boto3

# Auto join wan pool
base_cluster="$(echo "${cluster_tag_value}" | sed -e 's/\-[a-z0-9]*$//')-1"
wan_ip="$(aws ec2 describe-instances --region "${region}" --filters "Name=tag:consul-servers,Values=$${base_cluster}" "Name=instance-state-name,Values=running" "Name=tag:Name,Values=*server*" | jq -r '[.Reservations[].Instances[].PrivateIpAddress][0]')"

for (( i = 0; i < 20; ++i )); do
    consul members -wan | grep -q "$${base_cluster}" && break
    consul join -wan "$wan_ip"
    sleep 10
done

# Fetch loadgen script - allows running arbitrary commands only
mkdir -p /opt/loadgen
aws s3 sync "s3://${s3_bucket}/loadgen/" /opt/loadgen/
python3 -c 'import pkg_resources; f = open("/tmp/boto3_version", "w"); boto3_version = (pkg_resources.get_distribution("boto3").version); f.write(boto3_version + "\n"); f.close()'

# Poor man's method to keep this running
nohup bash -c "
while : ; do
    python3 /opt/loadgen/runTest.py '${s3_bucket}'
    echo 'Unexpected death.. Restarting..'
    sleep 5
done" &> /var/log/loadgen.log &
