#!/usr/bin/python -tt

# Simple wrapper to trigger a locust run
# Reads configuration from S3
# TaskSet defined in local locustfile.py

from argparse import Namespace
from locust import runners

import boto3
import json
import os
import random
import subprocess
import sys
import time

import locustfile # noqa

s3 = boto3.client('s3', config=Config(signature_version='s3v4')

# Read bucketname from first argument or from LOADGEN_BUCKET_NAME env if no arg
if len(sys.argv) < 2:
    print('no arguments, attempting to read bucketname from env LOADGEN_BUCKET_NAME')
    bucket = os.getenv('LOADGEN_BUCKET_NAME', 'bucket-testing-loadgen')
else:
    bucket = sys.argv[1]

# This can probably stay static
key = 'test.json'

# upload a file matching the above keyname to the s3 bucket, example file:
# $ cat test.json
# {
#     "clients_per_node": 10,
#     "hatch_rate": 1,
#     "targets": [
#        "http://consul1.foo.bar:8500",
#        "http://consul2.foo.bar:8500",
#        "http://consul3.foo.bar:8500"
#     ],
#     "cmds": ["ls", "/bin/true"],
#     "run": false,
#     "run_time": "10s"
# }

while True:
    obj = s3.get_object(Bucket=bucket, Key=key)
    # py2 and py3 boto behaves differently, six module could work here
    if sys.version_info[0] < 3:
        config = json.loads(obj['Body'].read())
    else:
        config = json.loads(obj['Body'].read().decode('utf-8'))

    for cmd in config.get('cmds', []):
        subprocess.run(cmd, shell=True)

    # Do not run locust test if this is a server but still lets us run
    # arbitrary commands
    is_consul_server = subprocess.run("consul info | grep -q 'server = true'", shell=True).returncode == 0

    if not config.get('run', False) or is_consul_server:
        print('not running')
        time.sleep(30)
    else:
        opts = Namespace()
        # disable webui to give us run_time option
        opts.no_web = True
        # number of clients to simulate per node
        opts.num_clients = config.get('clients_per_node', 1)
        # how quickly we spawn new clients
        opts.hatch_rate = config.get('hatch_rate', 1)
        # locust doesn't natively support multiple targets, so we do this:
        opts.host = random.choice(config.get('targets', ['']))
        # run time of the test
        opts.run_time = config.get('run_time', '10s')

        if opts.host == '':
            print('no target')
            time.sleep(10)
        else:
            runners.locust_runner = runners.LocalLocustRunner([locustfile.MyLocust], opts)
            runners.locust_runner.start_hatching(wait=True)
            runners.locust_runner.greenlet.join()

            for name, value in runners.locust_runner.stats.entries.items():
                print(name, value.min_response_time, value.median_response_time, value.max_response_time, value.total_rps)
            print('test over, repeat')
            time.sleep(1)
