resource "aws_iam_role" "asg_iam_role" {
  name = "${var.vpc_name}-asg_iam_role"

  assume_role_policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Action": "sts:AssumeRole",
      "Principal": {
        "Service": "ec2.amazonaws.com"
      },
      "Effect": "Allow",
      "Sid": "AllowAssumeFromEC2"
    }
  ]
}
EOF

  tags = "${local.common_tags}"
}

resource "aws_iam_instance_profile" "asg_instance_profile" {
  name = "${var.vpc_name}-asg_instance_profile"
  role = "${aws_iam_role.asg_iam_role.name}"
}

# Required to fetch loadgen scripts
resource "aws_iam_role_policy" "asg_iam_role_policy" {
  name = "asg_iam_role_policy"
  role = "${aws_iam_role.asg_iam_role.id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
        "s3:GetObject",
        "s3:GetObjectTagging",
        "s3:GetObjectVersion",
        "s3:ListBucket"
      ],
      "Resource": [
        "arn:aws:s3:::tf-io-consul-chaos-${var.vpc_name}",
        "arn:aws:s3:::tf-io-consul-chaos-${var.vpc_name}/*"
      ]
    }
  ]
}
EOF
}

# Provided automatically by consul-cluster module
# Required for consul to "discover" each other
resource "aws_iam_role_policy" "asg_auto_discover_cluster" {
  name = "auto-discover-cluster"
  role = "${aws_iam_role.asg_iam_role.id}"

  policy = <<EOF
{
  "Version": "2012-10-17",
  "Statement": [
    {
      "Effect": "Allow",
      "Action": [
          "ec2:DescribeTags",
          "ec2:DescribeInstances",
          "autoscaling:DescribeAutoScalingGroups"
      ],
      "Resource": "*"
    }
  ]
}
EOF
}
