module "consul_custer_1" {
  source = "./modules/consul-cluster"

  cluster_name = "${var.vpc_name}-${var.cluster_name}-1"
  ami_id       = "${var.ami_id}"
  num_servers  = "${var.num_servers}"
  num_clients  = "${var.num_clients}"

  server_instance_type = "${var.server_instance_type}"
  client_instance_type = "${var.client_instance_type}"

  vpc_id                = "${aws_vpc.my-vpc.id}"
  subnet_ids            = "${aws_subnet.private.*.id}"
  instance_profile_name = "${aws_iam_instance_profile.asg_instance_profile.name}"
  s3_bucket             = "${aws_s3_bucket.configs.bucket}"
}

module "consul_custer_2" {
  source = "./modules/consul-cluster"

  cluster_name = "${var.vpc_name}-${var.cluster_name}-2"
  ami_id       = "${var.ami_id}"
  num_servers  = "${var.num_servers}"
  num_clients  = "${var.num_clients}"

  server_instance_type = "${var.server_instance_type}"
  client_instance_type = "${var.client_instance_type}"

  vpc_id                = "${aws_vpc.my-vpc.id}"
  subnet_ids            = "${aws_subnet.private.*.id}"
  instance_profile_name = "${aws_iam_instance_profile.asg_instance_profile.name}"
  s3_bucket             = "${aws_s3_bucket.configs.bucket}"
}

module "consul_custer_3" {
  source = "./modules/consul-cluster"

  cluster_name = "${var.vpc_name}-${var.cluster_name}-3"
  ami_id       = "${var.ami_id}"
  num_servers  = "${var.num_servers}"
  num_clients  = "${var.num_clients}"

  server_instance_type = "${var.server_instance_type}"
  client_instance_type = "${var.client_instance_type}"

  vpc_id                = "${aws_vpc.my-vpc.id}"
  subnet_ids            = "${aws_subnet.private.*.id}"
  instance_profile_name = "${aws_iam_instance_profile.asg_instance_profile.name}"
  s3_bucket             = "${aws_s3_bucket.configs.bucket}"
}
