resource "aws_security_group" "sg_allow_all_icmp" {
  name        = "${var.cluster_name}-allow-all-icmp"
  description = "allow incoming ping"

  vpc_id = "${var.vpc_id}"

  tags = "${merge(
    local.common_tags,
    map(
      "Name", "${var.cluster_name}-allow-all-icmp"
    )
  )}"
}

resource "aws_security_group_rule" "sgrule_allow_all_icmp" {
  type        = "ingress"
  from_port   = -1
  to_port     = -1
  protocol    = "icmp"
  cidr_blocks = ["0.0.0.0/0"]

  security_group_id = "${aws_security_group.sg_allow_all_icmp.id}"
}
