# ---------------------------------------------------------------------------------------------------------------------
# ENVIRONMENT VARIABLES
# Define these secrets as environment variables
# ---------------------------------------------------------------------------------------------------------------------

# AWS_ACCESS_KEY_ID
# AWS_SECRET_ACCESS_KEY
# AWS_DEFAULT_REGION

# ---------------------------------------------------------------------------------------------------------------------
# REQUIRED PARAMETERS
# ---------------------------------------------------------------------------------------------------------------------
variable "vpc_name" {
  description = "The name of your VPC. Please use your username as the value"
}

# ---------------------------------------------------------------------------------------------------------------------
# OPTIONAL PARAMETERS
# These parameters have reasonable defaults.
# ---------------------------------------------------------------------------------------------------------------------
variable "bastion_ami_id" {
  description = "The AMI to use for public access"
  default     = "ami-0f26419fe983ef55f"
}

# https://wiki.twitch.com/display/SYS/How+to+provide+access+to+your+service+over+WPA2+-+AEA%2C+APLL%2C+Osiris
variable "enable_corp_only_prefix" {
  description = "Limit ingress from from Amazon Corp Location"
  default     = "true"
}

variable "corp_only_prefix" {
  description = "List of APLL prefixes. Refer to https://apll.corp.amazon.com/. Defaults to us-west-2 corp prefix"
  default     = ["pl-f8a64391"]
}
