# ---------------------------------------------------------------------------------------------------------------------
# Common variables shared across root and child modules
# ---------------------------------------------------------------------------------------------------------------------
variable "aws_region" {
  description = "AWS Region to run in"
  default     = "us-west-2"
}

variable "ami_id" {
  description = "The ID of the AMI to run in the cluster. This should be an AMI built from the Packer template under examples/consul-ami/consul.json. To keep this example simple, we run the same AMI on both server and client nodes, but in real-world usage, your client nodes would also run your apps. If the default value is used, Terraform will look up the latest AMI build automatically."
  default     = "ami-0f26419fe983ef55f"
}

variable "cluster_name" {
  description = "What to name the Consul cluster and all of its associated resources"
  default     = "consul-test"
}

variable "num_servers" {
  description = "The number of Consul server nodes to deploy. We strongly recommend using 3 or 5."
  default     = 3
}

variable "num_clients" {
  description = "The number of Consul client nodes to deploy. You typically run the Consul client alongside your apps, so set this value to however many Instances make sense for your app code."
  default     = 1
}

variable "server_instance_type" {
  type        = "string"
  description = "The instance type of the consul server"
  default     = "c4.4xlarge"
}

variable "client_instance_type" {
  type        = "string"
  description = "The instance type of the consul client"
  default     = "t2.medium"
}

variable "cluster_tag_key" {
  description = "The tag the EC2 Instances will look for to automatically discover each other and form a cluster."
  default     = "consul-servers"
}

variable "ssh_key_name" {
  description = "The name of an EC2 Key Pair that can be used to SSH to the EC2 Instances in this cluster. Set to an empty string to not associate a Key Pair."
  default     = ""
}

variable "spot_price" {
  description = "The maximum hourly price to pay for EC2 Spot Instances."
  default     = ""
}

variable vpc_cidr_block {
  description = "vpc cidr block"
  default     = "172.16.0.0/18"  // 16382 hosts
}

// only need space for a few hosts
variable public_subnet1_cidr {
  description = "CIDR for public subnet 1"
  default     = "172.16.0.0/27"            // 30 hosts
}

locals {
  availability_zones = [
    "${var.aws_region}a",
    "${var.aws_region}a",
    "${var.aws_region}a",
    "${var.aws_region}a",
  ]

  common_tags = {
    Service     = "vidcs/tf-io-consul-chaos"
    Owner       = "video-coreservices@twitch.tv"
    Environment = "dev"
  }
}

variable private_subnets_cidr {
  description = "List of private subnets"

  default = [
    "172.16.8.0/21",  // 2046 hosts
    "172.16.16.0/21",
    "172.16.24.0/21",
    "172.16.32.0/21",
  ]
}
