# tf-io-consul-master-asg
Simple ASG and resources for Xenial consul-masters. Repo based on other tf-io modules the team has written.

TODO: modularize the ASG component.

<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
**Table of Contents**

- [Getting Started](#getting-started)
- [Requirements](#requirements)
  - [Providers](#providers)
  - [Inputs](#inputs)
  - [Outputs](#outputs)
- [Planning and deploying](#planning-and-deploying)
- [Creating new VPCe and updating regional support](#creating-new-vpce-and-updating-regional-support)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Getting Started

1. Clone the repository

2. Download the following (assuming MacOS)

  * [tfenv](https://github.com/tfutils/tfenv#automatic) --> `brew install tfenv`
  * [terrafile](https://github.com/coretech/terrafile#how-to-install) --> `brew tap coretech/terrafile && brew install terrafile`

3. In the root directory, run `tfenv install`

4. Copy the credentials for your AWS account in your shell (i.e: isengard temporary creds, other mechanisms)

5. See if your terraform environment can set up. In the root directory, run `./deploy.sh -e [staging|prod] -r <aws_region> init`

## Requirements

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
### Providers

| Name | Version |
|------|---------|
| aws | ~> 2.34.0 |
| template | ~> 2.1 |
| terraform | n/a |

### Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:-----:|
| asg\_size | Static size of the ASG | `number` | `5` | no |
| aws\_region | The AWS region this service will be deployed | `string` | `"us-west-2"` | no |
| backend\_bucket | The S3 bucket to store terraform remote state | `any` | n/a | yes |
| env | Service environment - (prod\|staging) | `string` | `"staging"` | no |
| instance\_type | EC2 instance type this service will be running on | `string` | `"c5.4xlarge"` | no |
| role | Service role (now known as machine class) | `any` | n/a | yes |
| vpce\_allowed\_principals | The list of trusted accounts for the VPCe. | `list` | `[]` | no |

### Outputs

| Name | Description |
|------|-------------|
| consul\_elb\_arn | The ARN of the ELB created to front the consul cluster in this region, env. |
| consul\_lb\_tg\_arn | The ARN of the target group of the ELB created to front the consul cluster in this region, env. |
| consul\_vpce\_name | The name for the consul VPC endpoint service. Used by consumers to discover service endpoints when they create interface endpoints in their account(s). |
| consul\_vpce\_service\_dns\_name | The base DNS name of the VPC endpoint service created. Will not be directly used in production. |
| consul\_vpce\_service\_private\_dns\_name | The private DNS name of the VPC endpoint service created. Will be empty on initial creation. Once created, will output the private DNS name. |

<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->

## Planning and deploying

**IMPORTANT**: When bootstrapping, please follow this deploy order, as there are race conditions applying ssl related resources.

1. Make sure the account you're running this with has a terraform S3 and dynamoDB setup (see output of [VIDCS-1905](https://jira.twitch.com/browse/VIDCS-1905)). Copy relevant conf files in `conf/<env>/<region>`. ([see us-east-1's configuration as an example](conf/prod/us-east-1))

1. Bootstrap the ACM cert for the region `cd bootstrap_acm && ./deploy.sh -e [staging|prod] -r <aws_region> (plan|apply)`

1. Carry out the validation of the SAN cert by creating the CNAME record under the `consul.live-video.a2z.com` subdomain. Create here: https://tiny.amazon.com/cjhwzpdq/IsenLink

  ![Tutorial of step 4](imgs/img_tutorial.png)

  Note: make sure not to duplicate the subdomain when entering the record name using `san_validation_resource_record_name`.

  Validation should take less than 30 minutes once both CNAME records are validated. The timeout for completion is 72 hours.

1. Now let's build the infra from the **root** directory. Always plan before deploying `./deploy.sh -e [staging|prod] -r <aws_region> plan`

1. Once your plan has gotten sign off, apply `./deploy.sh -e [staging|prod] -r <aws_region> apply`

## Creating new VPCe and updating regional support

1. To create a VPCe and surrounding infra for a new region, follow [these direction](https://git.xarth.tv/video-coreservices/tf-mod-vpce-service#setting-private-dns-manual) to set up private DNS. Update the [consul best practices](https://wiki.twitch.com/display/VID/Consul+Best+Practices+-+Video+Platform) wiki with the new endpoint(s).

1. To allow a new service account to connect to a region's VPCe, update the list of ARNs of the variable `vpce_allowed_principals` in the relevant regional config under `conf/prod/<region>/variables.tfvars`. If the account has not yet defined a list, instantiate one with the account you want to onboard.
