<!-- START doctoc generated TOC please keep comment here to allow auto update -->
<!-- DON'T EDIT THIS SECTION, INSTEAD RE-RUN doctoc TO UPDATE -->
## Table of Contents

- [Requirements](#requirements)
  - [Providers](#providers)
  - [Inputs](#inputs)
  - [Outputs](#outputs)

<!-- END doctoc generated TOC please keep comment here to allow auto update -->

## Requirements

<!-- BEGINNING OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
### Providers

| Name | Version |
|------|---------|
| aws | ~> 2.28 |

### Inputs

| Name | Description | Type | Default | Required |
|------|-------------|------|---------|:-----:|
| asg\_size | Static size of the ASG | `number` | `5` | no |
| aws\_region | The AWS region this service will be deployed | `string` | `"us-west-2"` | no |
| backend\_bucket | The S3 bucket to store terraform remote state | `any` | n/a | yes |
| env | Service environment - (prod\|staging) | `string` | `"staging"` | no |
| instance\_type | EC2 instance type this service will be running on | `string` | `"c5.4xlarge"` | no |
| role | Service role (now known as machine class) | `any` | n/a | yes |
| vpce\_allowed\_principals | The list of trusted accounts for the VPCe. | `list` | `[]` | no |

### Outputs

| Name | Description |
|------|-------------|
| consul\_cert\_arn | The ARN of the ACM certificate created. |
| san\_validation\_resource\_record\_name | The route 53 record name to be configured for the consul SAN cert. |
| san\_validation\_resource\_record\_type | The route 53 record type to be configured for the consul SAN cert. |
| san\_validation\_resource\_record\_value | The route 53 record value to be configured for the consul SAN cert. |

<!-- END OF PRE-COMMIT-TERRAFORM DOCS HOOK -->
