terraform {
  required_version = ">= 0.12"

  backend "s3" {
  }
}

provider "aws" {
  region  = "${var.aws_region}"
  version = "~> 2.28"
}

locals {
  consul_subdomain = "${var.aws_region}.${var.env}.consul.live-video.a2z.com"
}

# ACM cert for the region, env this is built on.
resource "aws_acm_certificate" "consul_cert" {
  domain_name       = "api.${local.consul_subdomain}"
  validation_method = "DNS"

  # allow a path to a "global" UI entrypoint
  subject_alternative_names = [
    "ui.${var.env}.consul.live-video.a2z.com"
  ]

  tags = local.common_tags

  lifecycle {
    create_before_destroy = true
  }
}

# Get the zone ID of the subdomain (managed here https://git.xarth.tv/video-coreservices/tf-io-vidcs-dns-delegations)
# but it'll be in the same account the subdomain is managed by.
data "aws_route53_zone" "consul_subdomain_zone" {
  name         = local.consul_subdomain
  private_zone = false
}

# make the record for the subdomain validation
resource "aws_route53_record" "consul_cert_validate_record" {
  zone_id = data.aws_route53_zone.consul_subdomain_zone.zone_id
  name    = aws_acm_certificate.consul_cert.domain_validation_options.0.resource_record_name
  type    = aws_acm_certificate.consul_cert.domain_validation_options.0.resource_record_type
  ttl     = "300"
  records = [aws_acm_certificate.consul_cert.domain_validation_options.0.resource_record_value]
}
