#!/usr/bin/env bash

set -eo pipefail

ENV="staging"
REGION="us-west-2"

while getopts ":e:r:" opt; do
  case ${opt} in
    e )
      ENV=$OPTARG
      ;;
    r )
      REGION=$OPTARG
      ;;
    \? )
      echo "Usage: $0 [ -e prod|staging ][ -r <aws_region> ] [init|plan|apply]" 1>&2
      exit 1
      ;;
  esac
done

requirements() {
    command -v tfenv &> /dev/null || ( echo "tfenv required but missing" && exit 1 )
}

tf_init() {
    shift

    terraform init "$@" -reconfigure -backend-config="../conf/${ENV}/${REGION}/backend_bootstrap_acm.tfvars"
}


requirements


shift $((OPTIND-1))

case "$1" in
    init)
        tf_init "$@"
        ;;
    plan|apply)
        tf_init "$@"
        exec terraform "$@" \
            -var-file="../conf/${ENV}/${REGION}/variables.tfvars"
        ;;
    *)
        exec terraform "$@"
        ;;
esac
