terraform {
  required_version = ">= 0.12"

  backend "s3" {
  }
}

# Get all subnets (I backported tags for the consul clusters in the party account)
data "aws_subnet_ids" "consul_vpc_subnets_raw" {
  vpc_id = local.consul_vpc

  filter {
    name   = "tag:aws-cdk:subnet-type"
    values = ["Private"]
  }
}

locals {
  consul_vpc_subnets = toset(data.aws_subnet_ids.consul_vpc_subnets_raw.ids)
}

module "autoscale_dns" {
  source                              = "./vendor/modules/terraform-aws-asg-dns-handler"
  autoscale_handler_unique_identifier = "dns-asg-handler"
  autoscale_route53zone_id            = local.consul_r53_zone_id
  vpc_name                            = local.consul_vpc
}
